//
//	Class definition for Test Dialog class
//

#ifndef THE_TOMBSTONE_DIALOG_H
#define THE_TOMBSTONE_DIALOG_H

#include "ldwTiledDialog.h"
#include "ldwImage.h"
#include "ldwGameWindow.h"
#include "../Game/theGameState.h"
#include "../Utils/theStringManager.h"

class ldwButton;
class ldwTextControl;
//class ldwSoundTrack;
//class ldwSoundFx;
typedef enum
{
	eTSGreenCanvas,
	eTSRedCanvas,
	eTSOrangeCanvas,
	eTSNoColor
} TSDialogColorEnum;	


class theTombStoneDialog : public ldwTiledDialog
{
public:

	theTombStoneDialog(TSDialogColorEnum dialogCanvas, const CGraveyard::SGrave *psGrave);
	~theTombStoneDialog();

	int  GetResult();

	bool HandleMessage(int messageId,long data);

private:

	const CGraveyard::SGrave *	m_psGrave;

	const int cChoiceAButtonID;

	theGameState * gs;

	ldwGameWindow *gameWindow;
	theStringManager *strMgr;
	ldwTextControl *eulogyField;
protected:
	bool paramaterUsed ;
	enum {eExitButtonId = 1, eNameInputId};

	ldwImageGrid       *mTiles;

	void DrawNoFadeScene();

	ldwButton      *choiceAButton;
	
	int  mResult;
};

#endif
